#include <built_in.h>
#include "Si5351SDR.h"
#include "SSD1306OLED.c"
#define   N   20
unsigned long Freq = 10000000;
unsigned long StepVal;
char LCDText[15];
char StepCnt = 0x03;
char ModeCnt = 0x01;
char TuneFlag = 0x00;
unsigned PrintCnt = 0x00;
unsigned VBat = 0;
signed short EncodeVals[] = {0,-1,1,0,};
///////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////
void sendRegister(char reg_addr, char reg_value){
  I2C1_Start();
  I2C1_Wr(SI5351A_ADDRESS);
  I2C1_Wr(reg_addr);
  I2C1_Wr(reg_value);
  I2C1_Stop();
}
void si5351aSetFrequency(unsigned long frequency){
        unsigned divider;
        unsigned long pllFreq;
        unsigned long xtalFreq = Si5351A_XTAL_FREQ;
        unsigned long l;
        float f;
        unsigned char mult;
        unsigned long num;
        unsigned long denom;
        if(frequency < 9050001)divider = 124;
        if(frequency > 9050000)divider = 44;
        if(frequency > 16000000)divider = 20;
        pllFreq = divider * frequency;        // Calculate the pllFrequency: the divider * desired output frequency
        mult = pllFreq / xtalFreq;                // Determine the multiplier to get to the required pllFrequency
        l = pllFreq % xtalFreq;                        // It has three parts:
        f = l;                                                        // mult is an integer that must be in the range 15..90
        f *= 1048575;                                        // num and denom are the fractional parts, the numerator and denominator
        f /= xtalFreq;                                        // each is 20 bits (range 0..1048575)
        num = f;                                                // the actual multiplier is  mult + num / denom
        denom = 1048575;                                // For simplicity we set the denominator to the maximum 1048575
        setupPLL(SI_SYNTH_PLL_A, mult, num, denom);      // Set up PLL A with the calculated multiplication ratio
        setupMultisynth(SI_SYNTH_MS_0, divider, SI_R_DIV_1);
        setupMultisynth(SI_SYNTH_MS_1, divider, SI_R_DIV_1);
        sendRegister(CLK0_PHOFF,divider);
        sendRegister(CLK1_PHOFF, 0);
}
//////////////////////////////////////////////////////////////////////////////////////
void setupPLL(unsigned char pll, unsigned char mult, unsigned long num, unsigned long denom){
        unsigned long P1;                                        // PLL config register P1
        unsigned long P2;                                        // PLL config register P2
        unsigned long P3;                                        // PLL config register P3

        P1 = (unsigned long)(128 * ((float)num / (float)denom));
        P1 = (unsigned long)(128 * (unsigned long)(mult) + P1 - 512);
        P2 = (unsigned long)(128 * ((float)num / (float)denom));
        P2 = (unsigned long)(128 * num - denom * P2);
        P3 = denom;

        sendRegister(pll + 0, (P3 & 0x0000FF00) >> 8);
        sendRegister(pll + 1, (P3 & 0x000000FF));
        sendRegister(pll + 2, (P1 & 0x00030000) >> 16);
        sendRegister(pll + 3, (P1 & 0x0000FF00) >> 8);
        sendRegister(pll + 4, (P1 & 0x000000FF));
        sendRegister(pll + 5, ((P3 & 0x000F0000) >> 12) | ((P2 & 0x000F0000) >> 16));
        sendRegister(pll + 6, (P2 & 0x0000FF00) >> 8);
        sendRegister(pll + 7, (P2 & 0x000000FF));
}
//////////////////////////////////////////////////////////////////////////////////////
void setupMultisynth(unsigned char synth, unsigned long divider, unsigned char rDiv){
        unsigned long P1;                                        // Synth config register P1
        unsigned long P2;                                        // Synth config register P2
        unsigned long P3;                                        // Synth config register P3
        P1 = 128 * divider - 512;
        P2 = 0; // P2 = 0, P3 = 1 forces an integer value for the divider
        P3 = 1;
        sendRegister(synth + 0,   (P3 & 0x0000FF00) >> 8);
        sendRegister(synth + 1,   (P3 & 0x000000FF));
        sendRegister(synth + 2,   ((P1 & 0x00030000) >> 16) | rDiv);
        sendRegister(synth + 3,   (P1 & 0x0000FF00) >> 8);
        sendRegister(synth + 4,   (P1 & 0x000000FF));
        sendRegister(synth + 5,   ((P3 & 0x000F0000) >> 12) | ((P2 & 0x000F0000) >> 16));
        sendRegister(synth + 6,   (P2 & 0x0000FF00) >> 8);
        sendRegister(synth + 7,   (P2 & 0x000000FF));
}
///////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////
unsigned ADCRead(){
  unsigned A2DSample = 0;
  ADCON0.Go = 1 ;
  while(ADCON0.Go == 1){}
  Hi(A2DSample) = ADRESH;
  Lo(A2DSample) = ADRESL;
  return A2DSample;
}
///////////////////////////////////////////////////////////////
void BatCheck(){
 while(PrintCnt < 50){
  PrintCnt ++;
  VBat = ADCRead();
  VBat = (VBat*(N-1) + VBat)/N;
  VBat = (VBat * 52)/80;
 }
  wordtostr(VBat,LCDText);
  LCDText[0] = LCDTExt[2];
  LCDText[1] = '.';
  LCDText[2] = LCDTExt[3];
  LCDText[3] = 0;
  SSD1306_GotoXY(26,10);
  SSD1306_TextSize(2);
  SSD1306_Print("BATTERY");
  SSD1306_GotoXY(45,30);
  SSD1306_Print(LCDText);
  SSD1306_Print("v");
  SSD1306_Display();
  PrintCnt = 0;
  delay_ms(2500);
}
//////////////////////////////////////////////////////////////
void Tune(){
   TuneFlag = 0x00;
   while(EncodIn){
    SelectMode();
    SelectStep();
    delay_ms(2);
   }
   while((EncodIn)== 0){
    SelectMode();
    SelectStep();
   }
   delay_ms(3);
   Freq+=(EncodeVals[EncodIn]*StepVal);
   if(freq > 21000000)freq = 21000000;
   if(freq < 2700000) freq = 2700000;
   TuneFlag = 0xFF;
}
///////////////////////////////////////////////
unsigned long SelectStep(){
 if(StepSW == 1){
  StepCnt++;
  while(StepSW == 1);
  delay_ms(100);
  if(StepCnt > 6)StepCnt = 1;
  switch(StepCnt){
   case 1: StepVal = 10; print_10Hz; break;
   case 2: StepVal = 100; print_100Hz; break;
   case 3: StepVal = 1000; print_1KHz;  break;
   case 4: StepVal = 5000; print_5KHz;  break;
   case 5: StepVal = 100000; print_100KHz;  break;
   case 6: StepVal = 1; print_1Hz; break;
  }
 }
  return StepVal;
}
///////////////////////////////////////////////////////
void DisplayFreq(){
 longtostr(Freq, LCDText);
 LCDText[0] =  LCDText[3];
 LCDText[1] =  LCDText[4];
 LCDText[2] = 0;
 SSD1306_GotoXY(1,10);
 SSD1306_TextSize(3);
 SSD1306_Print(LCDText);
 SSD1306_Print(".");
 LCDText[0] =  LCDText[5];
 LCDText[1] =  LCDText[6];
 LCDText[2] =  LCDText[7];
 LCDText[3] =  LCDText[8];
 LCDText[4] =  0; 
 SSD1306_Print(LCDText);
 SSD1306_GotoXY(112,35);
 SSD1306_TextSize(1);
 LCDText[0] =  LCDText[9];
 LCDText[1] =  LCDText[10];
 LCDText[2] = 0;
 SSD1306_Print(LCDText);
 SSD1306_Display();
}
/////////////////////////////////////////////////////////
void SelectMode(){
 if(ModeSW == 1){
   ModeCnt++;
   while(ModeSW == 1);
   delay_ms(100);
   if(ModeCnt > 3)ModeCnt = 1;
   switch(ModeCnt){
    case 1: AMSel; print_AM; break;
    case 2: LSBSel; print_LSB; break;
    case 3: USBSel; print_USB; break;
   }
   sendRegister(SI_PLL_RESET, 0xA0);
 }
}
/////////////////////////////////////////////////////////
void Init_Main(){
 OSCCON = 0b01111010; //set up for 16 MHZ internal oscillator
 ANSELA = 0b00010000;
 ANSELC = 0b00000000;
 PORTA =  0b00000000;
 TRISA =  0b11111111;
 TRISC =  0b00000000;
 PORTC =  0b00000000;
 I2C1_Init(800000);
 VREFCON0 = 0b10100000;
 ADCON0 =   0b00010001;
 ADCON1 =   0b00001000;
 ADCON2 =   0b10010010;
 delay_ms(20);
 sendRegister(CLK_ENABLE_CONTROL, 0x00);
 sendRegister(SI_CLK0_CONTROL, 0x0F);
 sendRegister(SI_CLK1_CONTROL, 0x0F);
 sendRegister(SI_CLK2_CONTROL, 0x2C);
 setupPLL(SI_SYNTH_PLL_B, 25, 1048575, 1048575);
 setupMultisynth(SI_SYNTH_MS_2, 845, SI_R_DIV_16);
 si5351aSetFrequency(freq);
 sendRegister(SI_PLL_RESET, 0xA0);
 StepVal = 1000;
 ///////////////////////////////////////////////////////////
 SSD1306_Begin(SSD1306_SWITCHCAPVCC, SSD1306_I2C_ADDRESS);
 SSD1306_Color = false;
 SSD1306_ClearDisplay();
 SSD1306_Display();
 BatCheck();
 SSD1306_ClearDisplay();
 DisplayFreq();
 SSD1306_TextSize(2);
 print_AM;
 print_1KHz;

}
////////////////////////////////////////////////////
void main(){
 Init_Main();
 while(1){
  Tune();
  if(TuneFlag){
   si5351aSetFrequency(freq);
   DisplayFreq();
  }
 }
}